local JSON = require("./Infotainment/util/json")
local UI = require("./Infotainment/ui/displays")
local CALCULATIONS = require("./Infotainment/calculations/calculations")
local RADIO = require("./Infotainment/apps/radio")
local CUSTOMIZATION = require("./Infotainment/apps/customization")
local EXTRAS = require("./Infotainment/apps/extras")
local INFO = require("./Infotainment/apps/info")
local NAVIGATION = require("./Infotainment/apps/navigation")
local SENSORS = require("./Infotainment/apps/sensors")
local SETTINGS = require("./Infotainment/apps/settings")
local SPOTIFY = require("./Infotainment/apps/spotify")
local VEHICLE = require("./Infotainment/apps/vehicle")
local YOUTUBE = require("./Infotainment/apps/youtube")
local HOME = require("./Infotainment/apps/home")
local NOTIFICATIONS = require("./Infotainment/apps/notifications")
local AUTOUPDATER = require("./Infotainment/system/autoupdater")

usable_length = 684
usable_width = 331
usable_offset_x = 157
usable_offset_y = 053
background_resolution_x = 1280
background_resolution_y = 740
currentScreen = "HOME"
previousScreen = {}
screenSize = vec2(684, 331)

 colorCover = rgbm(0, 0, 0, 0)
 colorWhite = colorWhite
 colorSelection = rgbm(0.9, 0.5, 0, 0.0)
 colorHover = rgbm(0.2, 0.2, 0.2, 1)
 colorDisabled = rgbm(0.1, 0.1, 0.1, 1)
 selected = 1

local sensorsAlreadyTriggered = false

local startingMode = tonumber(ac.loadDisplayValue("startingMode", 4)) or 1
local previousSection = startingMode
local currentSection = startingMode
local activationProgress = 0
local version = "v0.51"

radio = {
    player = ui.MediaPlayer(),
    tuningPlayer = ui.MediaPlayer(),
    volume = 0.10,
    station = nil,
    state = false,
    stationsList = {},
    selectedCountry = nil,
    selectedPage = 0
}
local carSounds = ui.MediaPlayer()
local carSounds2 = ui.MediaPlayer()


--radio.player:setVolume(ac.getAudioVolume('main') * radio.volume)
radio.tuningPlayer:setVolume(ac.getAudioVolume('main') * radio.volume)
radio.tuningPlayer:setSource("./sounds/radio_tuning.mp3")
--radio.player:setSource("http://192.168.1.91:8081/api/youtube.mp3")
--player = ui.MediaPlayer()
--radio.player:play()
--radio.player:setLooping(true)

-- player:setSource('back.mp3'):setAutoPlay(true)
-- player:setVolume(0.5)
---
---function script.update(dt)
---  ui.drawImage(player, vec2(), vec2(400, 200))
---end

--local player = ui.MediaPlayer()
local vcolor = rgb(0, 0, 0)

local ambientLightDoorRight
ambientLightDoorRight = ac.LightSource(ac.LightType.Line, vec3(0, 0, 0))
ambientLightDoorRight.color = vcolor

local menuIsOpen = false

updatedRadioStationList()

function update(dt)
    --local test = web.get("http://192.168.1.91:8081/")
    -- updateold(dt)
    carputer()
    -- telemetry()

    if (currentScreen == "HOME") then
        DisplayHomePage()
        -- setWallpaper()
    elseif (currentScreen == "SPOTIFY") then
        DisplaySpotifyPage()
    elseif (currentScreen == "RADIO") then
        DisplayRadioPage()
    elseif (currentScreen == "NOTIFICATIONS") then
        DisplayNotificationsPage()
    elseif (currentScreen == "NAVIGATION") then
        DisplayNavigationPage()
    elseif (currentScreen == "EXTRAS") then
        DisplayExtrasPage()
    elseif (currentScreen == "SETTINGS") then
        DisplaySettingsPage()
    elseif (currentScreen == "SENSORS") then
        DisplaySensorsPage()
    elseif (currentScreen == "CUSTOMIZATION") then
        DisplayCustomizationPage()
    elseif (currentScreen == "VEHICLE") then
        DisplayVehiclePage()
    elseif (currentScreen == "YOUTUBE") then
        DisplayYoutubePage()
    elseif (currentScreen == "INFO") then
        DisplayInfoPage()
    end
    mouseAnimation()
    reverseCamera()

    --ui.drawImage(radio.player, vec2(0, 0), vec2(screenSize.x, screenSize.y), false)

end

function reverseCamera()
    if car.gear == -1 and sensorsAlreadyTriggered == false then
        table.insert(previousScreen, currentScreen)
        currentScreen = "SENSORS"
        sensorsAlreadyTriggered = true
    end
    if car.gear ~= -1 then
        if sensorsAlreadyTriggered == true and currentScreen == "SENSORS" then
            currentScreen = previousScreen[1]
            table.remove(previousScreen, 1)
        end
        sensorsAlreadyTriggered = false
    end
end


function disableNavAndStereo()
    ac.setDynamicTextureShift("NAVIGATOR_0", 0)
    ac.setDynamicTextureShift("CAR_STEREO_0", 0)
end

function enableNav()
    ac.setDynamicTextureShift("NAVIGATOR_0", 1)
    ac.setDynamicTextureShift("CAR_STEREO_0", 0)
end

function enableStereo()
    ac.setDynamicTextureShift("NAVIGATOR_0", 0)
    ac.setDynamicTextureShift("CAR_STEREO_0", 1)
end






function updateold(dt)
    if (ac.isMeshClicked("080-0-80", vec2(0, 0.75), vec2(0.15, 1), nil, 0.05)) then
        menuIsOpen = not menuIsOpen
    end

    -- if(ac.isMeshClicked("158-0-158.014", vec2(0, 0), vec2(0.5, 1), nil, 0.05)) then
    --    menuIsOpen = not menuIsOpen --VOLUME KEYS
    -- end

    if (menuIsOpen == true) then
        menu()
    else

        -- if(car.speedKmh > 25) then
        --	ac.setHeadlights(false)
        -- end
        -- if(car.speedKmh <= 25) then
        --	ac.setHeadlights(true)
        -- end

        -- Updating state
        if currentSection ~= previousSection then
            activationProgress = math.max(0, activationProgress - dt * 3)
            if activationProgress == 0 then
                ac.setDynamicTextureShift(buttons[previousSection].screen, 0)
                previousSection = currentSection
            end
        elseif activationProgress < 1 then
            activationProgress = math.min(1, activationProgress + dt * 3)
        end
        ac.setDynamicTextureShift(buttons[previousSection].screen, activationProgress)

        if buttons[previousSection].screen == "CAR_STEREO_0" then
            display.image {
                pos = vec2(-157, -54),
                size = vec2(900, 500),
                image = "Untitled-4.png"
            } -- and --draw fisheye camera
        end

        -- A bit of a placeholders (temporary?) for missing sections
        if buttons[previousSection].screen == nil then
            -- Restoring original background
            display.image {
                image = "car::Untitled-2.png",
                pos = vec2(-(usable_offset_x), -(usable_offset_y)),
                size = vec2(1024, 668)
            }

            if previousSection == 6 then
                settings()
            elseif buttons[previousSection].title == "DEBUG" then
                debug()
            elseif buttons[previousSection].title == "CURRENT_STATS" then
                setWallpaper()
                mouseAnimation()
                extraSettings()
                -- carSettings1()
                -- carSettings2()
            elseif buttons[previousSection].title == "360CAMERA" then
                setWallpaper()
                mouseAnimation()
                camera360()
            elseif buttons[previousSection].title == "RADIO" then
                setWallpaper()
                mouseAnimation()
                DisplayRadioPage()
            elseif buttons[previousSection].title == "COLOR" then
                setWallpaper()
                mouseAnimation()
                DisplayCarColorPage()
            elseif buttons[previousSection].title == "UITEST" then
                setWallpaper()
                mouseAnimation()
                UITEST()

            elseif buttons[previousSection].title ~= nil then
                ui.pushStyleVar(ui.StyleVar.Alpha, activationProgress)
                display.rect {
                    pos = vec2(),
                    size = vec2(1024, 668),
                    color = rgbm(0, 0, 0, 0.9)
                }
                display.text {
                    text = buttons[previousSection].title,
                    pos = vec2(0, 70),
                    letter = vec2(25, 50),
                    font = "sls",
                    width = 400,
                    alignment = 0.5
                }
                ui.popStyleVar()
            end
        end

        -- Buttons, also useful to recreate the curved mask
        local hoveredButton = 0
        ui.beginTextureSaturationAdjustment() -- adjusting texture to hide original selection
        ui.setShadingOffset(1, 0) -- this one is for color×2-0.5, along with desaturation hides selection
        ui.beginTextureShade("car::lcd2.dds") -- all shapes drawn here will get a texture mapped on top of them
        for i = 1, #buttons do
            local btn = buttons[i].points
            if ui.rectHovered(btn[1], btn[3]) then
                hoveredButton = i
                if ui.mouseClicked() then
                    currentSection = i
                end
            end
            ui.drawQuadFilled(btn[1], btn[2], btn[3], btn[4], colorWhite)
        end
        ui.endTextureSaturationAdjustment(0)
        ui.endTextureShade(vec2(), vec2(1024, 668))
        ui.setShadingOffset()

        -- Highlight for selected button
        if currentSection ~= 0 then
            local btn = buttons[currentSection].points
            ui.beginGradientShade()
            ui.drawQuadFilled(btn[2] - vec2(20, 0), btn[2], btn[3], btn[3] - vec2(20, 0), colorSelection)
            ui.endGradientShade(btn[2] - vec2(20, 0), btn[3], rgbm(0.9, 0.5, 0, 1), rgbm(0.9, 0.5, 0, 1))
        end

        -- Highlight for hovered button
        if hoveredButton ~= 0 and hoveredButton ~= currentSection then
            local btn = buttons[hoveredButton].points
            ui.beginGradientShade()
            ui.drawQuadFilled(btn[2] - vec2(20, 0), btn[2], btn[3], btn[3] - vec2(20, 0), colorHover)
            ui.endGradientShade(btn[2] - vec2(20, 0), btn[3], rgbm(0.9, 0.5, 0, 1), rgbm(0.9, 0.5, 00, 1))
        end

        -- Reception indicator to reduce in tunnels or with bad weather
        local satelliteOcclusion = ac.estimateSatelliteOcclusion()
        if satelliteOcclusion < 0.25 then
            display.rect {
                pos = vec2(340.8, 382.4),
                size = vec2(16.8, 19.8),
                color = colorCover
            }
        elseif satelliteOcclusion < 0.5 then
            display.rect {
                pos = vec2(346.1, 382.1),
                size = vec2(11.7, 19.4),
                color = colorCover
            }
        elseif satelliteOcclusion < 0.75 then
            display.rect {
                pos = vec2(351.5, 382.4),
                size = vec2(5.7, 19.1),
                color = colorCover
            }
        end

        if car.gear ~= -1 then
            -- If gear is not reverse, activate navigator:
            ac.setRenderingCameraActive("RENDERING_CAMERA_0", true) -- pause rendering camera
            return -- and we’re done here, so let’s stop
        end

        -- Gear is reverse!
        ac.setDynamicTextureShift("NAVIGATOR_0", 0) -- let’s stop navigator
        ac.setDynamicTextureShift("CAR_STEREO_0", 0) -- let’s stop navigator
        ac.setDynamicTextureShift("CAR_STEREO_1", 0) -- let’s stop navigator
        ac.setRenderingCameraActive("RENDERING_CAMERA_0", 0) -- activate rendering camera
        display.image {
            pos = vec2(usable_length, 0),
            size = vec2(-(usable_length), usable_width),
            image = "dynamic::camera_rear_distorted"
        } -- and draw fisheye camera

        -- And we’re done! But for a bit of extra authenticity let’s add lines with trajectory:
        local startL = vec2(150, 320) -- one thing to note: I haven’t really properly calibrated those lines yet
        local startR = vec2(usable_length - 150, 320)
        local direction = vec2(15, -25):normalize()
        local lineLen = 160
        local steps = 9
        local steerOffset = car.steer * 0.12
        local currentPosL = startL
        local currentPosR = startR
        local color = colorHover
        for i = 1, steps do
            local newPosL = startL + direction * (i * (lineLen / steps)) + vec2(steerOffset * (i / steps) ^ 2, 0)
            local newPosR = startR + vec2(-direction.x, direction.y) * (i * (lineLen / steps)) +
                                vec2(steerOffset * (i / steps) ^ 2, 0)
            local drawAcrossColor = color
            if i == 4 then
                color = rgbm(1, 1, 0, 1)
            elseif i == 7 then
                color = rgbm(0, 1, 0, 1)
            else
                drawAcrossColor = i == 9 and color or nil
            end
            ui.drawLine(currentPosL, newPosL, color, 4)
            ui.drawLine(currentPosR, newPosR, color, 4)
            if drawAcrossColor ~= nil then
                ui.drawLine(currentPosL, currentPosR, drawAcrossColor, 4)
            end
            currentPosL = newPosL
            currentPosR = newPosR
            direction:add(vec2(0, 0.02)):normalize()
        end

        -- And a warning:
        -- display.rect{pos = vec2(320, 76), size = vec2(396, 32), color = rgbm(0, 0, 0, 0.8 )}
        -- display.text{pos = vec2(320, 86), letter = vec2(12, 20), text = "Check surroundings for safety", font = "aria", width = 396, alignment = 0.5 }
    end
end

function settings()
    local whiteColor = colorWhite
    local accentColor = rgbm(1, 0.1, 0.1, 1)

    function radioButton(text, pos, mode)
        display.text {
            text = text,
            pos = pos,
            letter = vec2(11, 22),
            font = "sls"
        }

        local circlePos = pos + vec2(-20, 10)
        ui.drawCircleFilled(circlePos, 10, whiteColor, 20)

        local hovered = ui.rectHovered(circlePos - 10, circlePos + vec2(110, 10))
        if startingMode == mode then
            ui.drawCircleFilled(circlePos, 8, accentColor)
        elseif hovered then
            ui.drawCircleFilled(circlePos, 8, rgbm(0.4, 0.4, 0.4, 1))
            if ui.mouseClicked() then
                startingMode = mode
                ac.saveDisplayValue("startingMode", mode)
            end
        end
    end

    ui.pushStyleVar(ui.StyleVar.Alpha, activationProgress)
    display.rect {
        pos = vec2(),
        size = vec2(1024, 668),
        color = rgbm(0, 0, 0, 0.9)
    }
    display.text {
        text = "Starting mode:",
        pos = vec2(350, 120),
        letter = vec2(20, 50),
        font = "sls"
    }
    radioButton("Navigator", vec2(500, 200), 4)
    radioButton("Radio", vec2(500, 250), 2)
    radioButton("Media", vec2(500, 300), 7)
    radioButton("Phone", vec2(500, 350), 3)
    radioButton("App", vec2(500, 400), 5)
    radioButton("Info", vec2(500, 450), 1)
    ui.popStyleVar()
end

function debug()
    function radioButton(text, pos, mode)
        display.text {
            text = text,
            pos = pos,
            letter = vec2(11, 22),
            font = "sls"
        }

        local circlePos = pos + vec2(-20, 10)
        ui.drawCircleFilled(circlePos, 510, whiteColor, 20)

        local hovered = ui.rectHovered(circlePos - 10, circlePos + vec2(110, 10))
        if startingMode == mode then
            ui.drawCircleFilled(circlePos, 8, accentColor)
        elseif hovered then
            ui.drawCircleFilled(circlePos, 8, rgbm(0.4, 0.4, 0.4, 1))
            if ui.mouseClicked() then
                page = mode
                -- startingMode = mode
                -- ac.saveDisplayValue("startingMode", mode)
            end
        end
    end
    radioButton("1", vec2(000, 000), 1)
    radioButton("2", vec2(000, 050), 2)
    radioButton("3", vec2(000, 100), 3)
    radioButton("4", vec2(000, 150), 4)
    radioButton("5", vec2(000, 200), 5)
    radioButton("6", vec2(000, 250), 6)
    radioButton("7", vec2(000, 300), 7)
    radioButton("8", vec2(000, 350), 8)
    if pcall(function()

        count = 0
        count2 = 0
        offset = -50
        for k, v in pairs(ac) do
            count2 = count2 + 1
            if ((count2 > (page - 1) * 18) and (count2 < (page * 18))) then
                -- if count2>18 then
                --	offset = offset + 300
                --	count2 = 0
                --	count = 0
                -- end
                -- textnew = textnew .. "\n" .. k
                display.text {
                    text = k,
                    buttons[previousSection].title,
                    pos = vec2(offset, count),
                    letter = vec2(10, 20),
                    font = "sls",
                    width = 400,
                    alignment = 1
                }
                if pcall(function()
                    if (k ~= "LightSource") then
                        v()
                    else
                        return error("LightSource")
                    end
                end) then
                    display.text {
                        text = v(),
                        buttons[previousSection].title,
                        pos = vec2(offset + 410, count),
                        letter = vec2(10, 20),
                        font = "sls",
                        width = 400,
                        alignment = 0
                    }
                else
                    display.text {
                        text = v,
                        buttons[previousSection].title,
                        pos = vec2(offset + 410, count),
                        letter = vec2(10, 20),
                        font = "sls",
                        width = 400,
                        alignment = 0
                    }
                end
                count = count + 20
            end
        end
    end) then
        test = 0
    else
        test = -1
    end
end

function currentStats()
    display.text {
        text = ac.getDriverNationCode(),
        pos = vec2(50, 50),
        letter = vec2(25, 50),
        font = "sls",
        width = 400,
        alignment = 1
    }

    display.text {
        text = math.floor(ac.getCarSpeedKmh() + 0.5),
        pos = vec2(50, 100),
        letter = vec2(25, 50),
        font = "sls",
        width = 400,
        alignment = 1
    }

    display.text {
        text = ac.getPatchVersion(),
        pos = vec2(50, 150),
        letter = vec2(25, 50),
        font = "sls",
        width = 400,
        alignment = 1
    }

    display.text {
        text = ac.isWeatherFxActive(),
        pos = vec2(50, 200),
        letter = vec2(25, 50),
        font = "sls",
        width = 400,
        alignment = 1
    }

    display.text {
        text = ac.getTrackId(),
        pos = vec2(50, 250),
        letter = vec2(25, 50),
        font = "sls",
        width = 400,
        alignment = 1
    }

    display.text {
        text = ac.getTrackLayout(),
        pos = vec2(50, 350),
        letter = vec2(25, 50),
        font = "sls",
        width = 400,
        alignment = 1
    }

    display.text {
        text = ac.getDriverName(),
        pos = vec2(50, 400),
        letter = vec2(25, 50),
        font = "sls",
        width = 400,
        alignment = 1
    }

end

function camera360()
    local offset = 200
    -- ac.setDynamicTextureShift("NAVIGATOR_0", 0)  -- let’s stop navigator
    -- ac.setDynamicTextureShift("CAR_STEREO_0", 0)  -- let’s stop navigator
    -- ac.setDynamicTextureShift("CAR_STEREO_1", 0)  -- let’s stop navigator
    ac.setRenderingCameraActive("RENDERING_CAMERA_1", 0) -- activate rendering camera
    display.image {
        pos = vec2(50, 0),
        size = vec2(offset - 50, ui.windowHeight() - 40),
        image = "dynamic::camera_360_distorted"
    } -- and draw fisheye camesra

    -- if car.gear ~= -1 then
    -- If gear is not reverse, activate navigator:
    ac.setRenderingCameraActive("RENDERING_CAMERA_0", true) -- pause rendering camera
    -- return -- and we’re done here, so let’s stop
    -- end

    -- Gear is reverse!
    ac.setDynamicTextureShift("NAVIGATOR_0", 0) -- let’s stop navigator
    ac.setDynamicTextureShift("CAR_STEREO_0", 0) -- let’s stop navigator
    ac.setDynamicTextureShift("CAR_STEREO_1", 0) -- let’s stop navigator
    ac.setRenderingCameraActive("RENDERING_CAMERA_0", 0) -- activate rendering camera
    display.image {
        pos = vec2(usable_length, 0),
        size = vec2(-(usable_length) + offset, ui.windowHeight() - 40),
        image = "dynamic::camera_rear_distorted"
    } -- and draw fisheye camera

    -- And we’re done! But for a bit of extra authenticity let’s add lines with trajectory:
    local startL = vec2(100 + offset, 300) -- one thing to note: I haven’t really properly calibrated those lines yet
    local startR = vec2(usable_length - 100, 300)
    local direction = vec2(15, -25):normalize()
    local lineLen = 160
    local steps = 9
    local steerOffset = car.steer * 0.12
    local currentPosL = startL
    local currentPosR = startR
    local color = rgbm(1, 0, 0, 1)
    for i = 1, steps do
        local newPosL = startL + direction * (i * (lineLen / steps)) + vec2(steerOffset * (i / steps) ^ 2, 0)
        local newPosR = startR + vec2(-direction.x, direction.y) * (i * (lineLen / steps)) +
                            vec2(steerOffset * (i / steps) ^ 2, 0)
        local drawAcrossColor = color
        if i == 4 then
            color = rgbm(1, 1, 0, 1)
        elseif i == 7 then
            color = rgbm(0, 1, 0, 1)
        else
            drawAcrossColor = i == 9 and color or nil
        end
        ui.drawLine(currentPosL, newPosL, color, 4)
        ui.drawLine(currentPosR, newPosR, color, 4)
        if drawAcrossColor ~= nil then
            ui.drawLine(currentPosL, currentPosR, drawAcrossColor, 4)
        end
        currentPosL = newPosL
        currentPosR = newPosR
        direction:add(vec2(0, 0.02)):normalize()
    end

    -- And a warning:
    -- display.rect{pos = vec2(320, 76), size = vec2(396, 32), color = rgbm(0, 0, 0, 0.8 )}
    -- display.text{pos = vec2(320, 86), letter = vec2(12, 20), text = "Check surroundings for safety", font = "aria", width = 396, alignment = 0.5 }

end

function carputer()
    local auto_headlights = false
    if auto_headlights then
        if ac.getSunAngle() > 85 then
            ac.setHeadlights(true)
        else
            ac.setHeadlights(false)
        end
    end
    -- light:dispose()

    if ((ac.getCar().turningLeftLights == true or ac.getCar().turningRightLights == true) and ac.isInteriorView() ==
        true) then
        -- if(carSounds:playing() ~= true) then
        carSounds:setSource('./sounds/turn_signals.mp3'):setAutoPlay(true)
        carSounds:setVolume(ac.getAudioVolume('main') * 0.03)
        carSounds:play()
        -- carSounds:setLooping(true)
        -- end
    else
        carSounds:pause()
        carSounds:setCurrentTime(0)
    end

    if ((ac.getCar().extraC == true) and ac.getCar().headlightsActive == true) and ac.isInteriorView() then
        -- if(carSounds2:playing() ~= true) then
        carSounds2:setSource('./sounds/chime.mp3'):setAutoPlay(true)
        carSounds2:setVolume(ac.getAudioVolume('main') * 0.03)
        carSounds2:play()
        -- carSounds2:setLooping(true)
        -- end
    else
        carSounds2:pause()
        carSounds2:setCurrentTime(0)
    end

    changeVolumeBasedOnPosition()
    carCompassRotation()
end

function carCompassRotation()
    local compass = ac.findNodes("Compass")
    compass:setRotation(vec3(0,0,1), math.rad(ac.getCompassAngle(ac.getCar().look)))
end



function DisplayCarColorPage()
    ui.childWindow("DisplayCarColorPage1", vec2(0, 25), function()
    end)
    ui.childWindow("DisplayCarColorPage2", vec2(450, 255), function()
        local color = ui.colorPicker("color", vcolor, ui.ColorPickerFlags.PickerHueWheel +
            ui.ColorPickerFlags.NoSidePreview + ui.ColorPickerFlags.NoLabel)
        --if (color) then
        --    ambientLightDoorRight:dispose()
        --    ambientLightDoorRight = ac.LightSource(ac.LightType.Line, vec3(0, 0, 0))
        --    ambientLightDoorRight.color = vcolor
        --end
        --ac.findMeshes("AmbientLEDDoorRight"):setMaterialProperty('ksEmissive', vcolor)
        --ac.findMeshes("AmbientLEDFront"):setMaterialProperty('ksEmissive', vcolor)
        --ac.findMeshes("AmbientLEDDoorLeft"):setMaterialProperty('ksEmissive', vcolor)
        ac.findMeshes("015-0-15"):setMaterialTexture('txDetail', vcolor:rgbm(1))--metal_detail.dds
        --ac.findMeshes("015-0-15"):setMaterialTexture('txDetail', "metal_detail.dds") --reset color
    end)
    ac.setRenderingCameraActive("RENDERING_CAMERA_2", 0) -- activate rendering camera
    -- ac.setRenderingCameraActive("RENDERING_CAMERA_3", 0) -- activate rendering camera
    -- ui.image("dynamic::camera_CarPaint1_distorted", vec2(200, 150))
    display.image {
        pos = vec2(screenSize.x / 2, 70),
        size = vec2(300, 250),
        image = "dynamic::camera_CarPaint1_distorted"
    } -- and draw fisheye camesra
end

function DisplayNotYetImplemented()
    display.text {
        text = "Functionality not implemented",
        pos = vec2(screenSize.x/15, screenSize.y/2.2),
        color = colorWhite,
        letter = vec2(20, 50),
        font = "sls",
        width = 200,
        alignment = 0.5
    }
end

function DisplayCustomMessage(text)
    display.text {
        text = text,
        pos = vec2(screenSize.x/15, screenSize.y/2.2),
        color = colorWhite,
        letter = vec2(20, 50),
        font = "sls",
        width = 200,
        alignment = 0.5
    }
end

function DisplayInformation()
    display.text {
        text = "RIS (RVZ Infotainment System) " .. version .. "",
        pos = vec2(screenSize.x/10, screenSize.y/4),
        color = colorWhite,
        letter = vec2(16, 40),
        font = "sls",
        width = 200,
        alignment = 0.5
    }

    display.text {
        text = "Implemented by RVZ",
        pos = vec2(screenSize.x/3.5, screenSize.y/2.2),
        color = colorWhite,
        letter = vec2(14, 35),
        font = "sls",
        width = 200,
        alignment = 0.5
    }

    display.text {
        text = "Follow the updates on Patreon: patreon.com/RVZGT",
        pos = vec2(screenSize.x/50, screenSize.y/1.5),
        color = colorWhite,
        letter = vec2(12, 30),
        font = "sls",
        width = 200,
        alignment = 0.5
    }

    display.text {
        text = "Come join our Discord community: discord.gg/FkEJKMnzJ5",
        pos = vec2(screenSize.x/50, screenSize.y/1.25),
        color = colorWhite,
        letter = vec2(12, 30),
        font = "sls",
        width = 200,
        alignment = 0.5
    }
end

function menu()
    -- local window = ui.childWindow("Child",vec2(usable_length-50, usable_width-50),true,ui.WindowFlags.None,fun)
    -- local color = window.colorPicker("color", vcolor, ui.ColorPickerFlags.PickerHueWheel)

    ui.tabBar('someTabBarID', ui.TabBarFlags.FittingPolicyResizeDown, function()
        ui.tabItem('Radio', ui.TreeNodeFlags.Animated, function()
            ui.treeNode("testLabel", ui.TreeNodeFlags.Animated, function()
                DisplayRadioPage()
            end)
        end)
        ui.tabItem('Customization', function()
            -- ui.toolWindow("testTool", ui.windowPos(), vec2(500,500), function()
            -- ui.childWindow("testChildWindow", vec2(ui.windowWidth()/2,0), ui.windowSize(), function()
            -- ui.childWindow("testChildWindow", vec2(ui.windowWidth()/2,ui.windowHeight()
            ui.childWindow("testChildWindow", vec2(ui.windowWidth(), 290), function()
                ui.treeNode("Paint Color", ui.TreeNodeFlags.CollapsingHeader, function()
                    ui.childWindow("testChildWindow", vec2(ui.windowWidth(), 290), function()
                        --  ui.transparentWindow("testTransWindow", ui.windowPos(), ui.windowSize(), function()
                        -- setWallpaper()
                        mouseAnimation()
                        -- ui.toast(ui.Icons.Apps, "Estão 4º lá fora foda-se não saias do carro caralho.")
                        -- ui.toolWindow("testsetsetst", ui.windowPos(), vec2(ui.windowWidth()/2,ui.windowHeight()), function()
                        ui.childWindow("testChildWwindow", vec2(ui.windowWidth() / 1.35, ui.windowHeight()), function()
                            DisplayCarColorPage()
                        end)
                        -- ui.childWindow("testChildWinwewedow", vec2(ui.windowWidth()/2,ui.windowHeight()
                        -- ), function()
                        -- ui.toolWindow("testset32wsetst", ui.windowPos() + vec2(ui.windowWidth()/2,0), vec2(ui.windowWidth()/2,ui.windowHeight()), function()
                        -- end)
                        ac.setRenderingCameraActive("RENDERING_CAMERA_2", 0) -- activate rendering camera
                        -- ac.setRenderingCameraActive("RENDERING_CAMERA_3", 0) -- activate rendering camera
                        ui.drawImage("dynamic::camera_CarPaint1_distorted", ui.windowContentSize() -
                            vec2(ui.windowContentSize().x / 3, ui.windowContentSize().y), ui.windowContentSize() -
                            vec2(0, 0) + vec2(usable_length - ui.windowContentSize().x, 0))
                        -- ui.drawImage("dynamic::camera_CarPaint2_distorted", ui.windowContentSize() - vec2(ui.windowContentSize().x/3,ui.windowContentSize().y/2), ui.windowContentSize() - vec2(0,ui.windowContentSize().y) + vec2(0, ui.windowContentSize().y))
                        -- ui.image("dynamic::camera_CarPaint1_distorted", vec2(200, 150))
                        -- ui.image("dynamic::camera_CarPaint2_distorted", vec2(200, 150))
                    end)
                    -- end)
                end)
                ui.treeNode("Ambient Lights Color", ui.TreeNodeFlags.CollapsingHeader, function()
                    ui.childWindow("testChildWindow", vec2(ui.windowWidth(), 290), function()
                        --  ui.transparentWindow("testTransWindow", ui.windowPos(), ui.windowSize(), function()
                        -- setWallpaper()
                        mouseAnimation()
                        -- ui.toast(ui.Icons.Apps, "Estão 4º lá fora foda-se não saias do carro caralho.")
                        -- ui.toolWindow("testsetsetst", ui.windowPos(), vec2(ui.windowWidth()/2,ui.windowHeight()), function()
                        ui.childWindow("testChildWwindow", vec2(ui.windowWidth() / 1.35, ui.windowHeight()), function()
                            DisplayCarColorPage()
                        end)
                        -- ui.childWindow("testChildWinwewedow", vec2(ui.windowWidth()/2,ui.windowHeight()
                        -- ), function()
                        -- ui.toolWindow("testset32wsetst", ui.windowPos() + vec2(ui.windowWidth()/2,0), vec2(ui.windowWidth()/2,ui.windowHeight()), function()
                        -- end)
                        ac.setRenderingCameraActive("RENDERING_CAMERA_2", 0) -- activate rendering camera
                        -- ac.setRenderingCameraActive("RENDERING_CAMERA_3", 0) -- activate rendering camera
                        ui.drawImage("dynamic::camera_CarPaint1_distorted", ui.windowContentSize() -
                            vec2(ui.windowContentSize().x / 3, ui.windowContentSize().y), ui.windowContentSize() -
                            vec2(0, 0) + vec2(usable_length - ui.windowContentSize().x, 0))
                        -- ui.drawImage("dynamic::camera_CarPaint2_distorted", ui.windowContentSize() - vec2(ui.windowContentSize().x/3,ui.windowContentSize().y/2), ui.windowContentSize() - vec2(0,ui.windowContentSize().y) + vec2(0, ui.windowContentSize().y))
                        -- ui.image("dynamic::camera_CarPaint1_distorted", vec2(200, 150))
                        -- ui.image("dynamic::camera_CarPaint2_distorted", vec2(200, 150))
                    end)
                    -- end)
                end)
            end)
        end)
        ui.tabItem('extraSettings', function()
            setWallpaper()
            mouseAnimation()
            extraSettings()
        end)
        ui.tabItem('telemetry', function()
            ui.childWindow("testChild45awqeWindow", ui.windowSize(), function()
                setWallpaper()
                ui.imageButton("dynamic::camera_CarPaint1_distorted", vec2(2000, 200))
                -- ui.imageButton("dynamic::camera_CarPaint1_distorted", vec2(200,500))
                mouseAnimation()
                telemetry()
            end)
        end)
        ui.tabItem('carSettings1', function()
            setWallpaper()
            mouseAnimation()

            ui.drawRect(vec2(20, 40), vec2(70, 90), rgb(1, 1, 1), 10, 15, 1.5)
            display.image({
                image = "./icons/arrow_left.png",
                pos = vec2(20, 40),
                size = vec2(50, 50)
            })
            if ui.rectHovered(vec2(20, 40), vec2(70, 90)) then
                ui.drawRect(vec2(20, 40), vec2(70, 90), rgb(1, 0, 1), 10, 15, 1.5)
                if ui.mouseClicked() then
                end
            end

            -- carSettings1()
        end)
        ui.tabItem('carSettings2', function()
            setWallpaper()
            mouseAnimation()
            carSettings2()
        end)
        ui.tabItem('camera360', function()
            setWallpaper()
            mouseAnimation()
            camera360()
        end)

    end)
end

function telemetry()
    local seriesMax = 17 -- how many elements there are in series
    local seriesValue = math.floor((car.rpm / 1000) * (seriesMax + 1)) -- from 0 to 10 active elements

    local seriesStartingPoint = vec2(0, 150) -- starting point (left top corner) of series, in pixels
    local seriesBitSize = vec2(5, 80) -- size of each series bit
    local seriesStepOffset = vec2(5, 0) -- offset of each series bit (12 pixels horizontally, 0 vertically)

    for i = 1, seriesValue do -- loop, repeat seriesValue times starting with 1
        local c1, c2, c3 = i / 100, 0, 0 -- do some dumb maths to get the black-to-red bar

        display.rect { -- just draw a simple rect for each bit in series
            pos = seriesStartingPoint + seriesStepOffset * (i - 1), -- for first element (i==1) offset is zero, for others multiply step by (i - 1)
            size = seriesBitSize,
            color = rgbm(c1, c2, c3, 1)
        }
    end
end

local usable_offset_x = 157
local usable_offset_y = 053

function setWallpaper()
    --  ui.drawRectFilled(vec2(0, 0), vec2(2000, 2000), rgbm(0, 0, 0, 1))
    -- ui.drawRectFilled(ui.windowPos(), ui.windowSize(), rgbm(0, 0, 0, 1))

    display.rect { -- just draw a simple rect for each bit in series
        pos = vec2(0, 0), -- for first element (i==1) offset is zero, for others multiply step by (i - 1)
        size = vec2(2000, 2000),
        color = rgbm(0, 0, 0, 1)
    }

    display.image({
        image = "./images/wallpaper_amp.jpg",
        pos = vec2(0, 0),
        size = screenSize,
        color = rgbm(0.25, 0.25, 0.25, 1)
    })

    -- ui.drawImage("./images/wallpaper_amp.jpg", vec2(0, 0), screenSize, rgbm(0.25, 0.25, 0.25, 1), true)
end

function setBlackBackgroundFooter()
    ui.drawRectFilled(vec2(0, ui.windowHeight() - 100), vec2(ui.windowWidth(), ui.windowHeight()), rgbm(0, 0, 0, 1))
    -- ui.drawRectFilled(ui.windowPos(), ui.windowSize(), rgbm(0, 0, 0, 1))
end

function extraSettings()

    local settings = {{
        text = "Extra A",
        stateText = function()
            if (ac.getCar().extraA == true) then
                return "ON"
            else
                return "OFF"
            end
        end,
        state = ac.getCar().extraA,
        method = function()
            ac.setExtraSwitch(0, not ac.getCar().extraA)
        end
    }, {
        text = "Extra B",
        stateText = function()
            if (ac.getCar().extraB == true) then
                return "ON"
            else
                return "OFF"
            end
        end,
        state = ac.getCar().extraB,
        method = function()
            ac.setExtraSwitch(1, not ac.getCar().extraB)
        end
    }, {
        text = "Extra C",
        stateText = function()
            if (ac.getCar().extraC == true) then
                return "ON"
            else
                return "OFF"
            end
        end,
        state = ac.getCar().extraC,
        method = function()
            ac.setExtraSwitch(2, not ac.getCar().extraC)
        end
    }, {
        text = "Extra D",
        stateText = function()
            if (ac.getCar().extraD == true) then
                return "ON"
            else
                return "OFF"
            end
        end,
        state = ac.getCar().extraD,
        method = function()
            ac.setExtraSwitch(3, not ac.getCar().extraD)
        end
    }, {
        text = "Extra E",
        stateText = function()
            if (ac.getCar().extraE == true) then
                return "ON"
            else
                return "OFF"
            end
        end,
        state = ac.getCar().extraE,
        method = function()
            ac.setExtraSwitch(4, not ac.getCar().extraE)
        end
    }, {
        text = "Extra F",
        stateText = function()
            if (ac.getCar().extraF == true) then
                return "ON"
            else
                return "OFF"
            end
        end,
        state = ac.getCar().extraF,
        method = function()
            ac.setExtraSwitch(5, not ac.getCar().extraF)
        end
    }}
    local posy = 0
    local posx = -1
    for i = 1, #settings do
        local setting = settings[i].text
        posx = posx + 1
        if i > 3 then
            if (posx > 2) then
                posx = 0
            end
            posy = 1
        end
        createSettingButton(setting, rgbm(0.1, 0.1, 0.1, 1), posx, posy, settings[i].stateText(), settings[i].method,
            settings[i].state)
    end
end

function createHomeMenuButton(text, color, positionX, positionY, state, method, on, image, p1, p2)
    local hoverColor = rgbm(0.4, 0.4, 0.4, 1)
    local buttonDistanceX = 25
    local buttonDistanceY = 50
    local padding = 10
    local paddingText = 5
    local size = (p2 - p1) / 3
    size = vec2(size.y, size.y)

    local newp1 = vec2(padding, padding) + vec2(p1.x, p1.y) + vec2(size.x * positionX, size.y * positionY) +
                      vec2(buttonDistanceX * positionX, buttonDistanceY * positionY)
    local newp2 = vec2(padding, padding) + vec2(p1.x, p1.y) + vec2(size.x * positionX, size.y * positionY) +
                      vec2(buttonDistanceX * positionX, buttonDistanceY * positionY) + vec2(size.x, size.y)
    if image ~= nil then
        ui.drawImage(image, newp1, newp2) -- ,rgbm.colors.white,vec2(0, 0),vec2(1, 1),true)
    end
    local textLocation = vec2(padding, padding) + vec2(p1.x, p1.y) + vec2(size.x * positionX, size.y * positionY) +
                             vec2(buttonDistanceX * positionX, buttonDistanceY * positionY) +
                             vec2(-size.x / 2, size.y + paddingText)
    display.text {
        text = state,
        pos = textLocation,
        color = colorWhite,
        letter = vec2(10, 25),
        font = "sls",
        width = 200,
        alignment = 0.5
    }
    if ui.rectHovered(newp1, newp2 + vec2(0, 30)) then
        -- ui.drawRect(newp1, newp2, hoverColor, 10, 15, 1.5)
        if image ~= nil then
            ui.drawImage(image, newp1, newp2, hoverColor) -- ,rgbm.colors.white,vec2(0, 0),vec2(1, 1),true)
        end
        if ui.mouseClicked() then
            method()
        end
    end
end

function createSettingButton(text, color, positionX, positionY, state, method, on, image)
    local accentColor = colorWhite
    local hoverColor = rgbm(0.5, 0.5, 0.5, 1)
    local offColor = rgbm(0.2, 0.2, 0.2, 1)
    local onColor = rgbm(1, 0.1, 0, 1)
    local buttonOffsetX = 60
    local buttonOffsetY = 80
    local buttonSizeX = 175
    local buttonSizeY = 100
    local buttonDistanceX = 25
    local buttonDistanceY = 25
    local color = hoverColor

    if (on) then
        color = onColor
    else
        color = offColor
    end

    if image ~= nil then
        ui.drawImage(image, vec2(buttonOffsetX + ((buttonSizeX * positionX) + (buttonDistanceX * positionX)),
            buttonOffsetY + ((buttonSizeY * positionY) + (buttonDistanceY * positionY))),
            vec2(buttonOffsetX + buttonSizeX + ((buttonSizeX * positionX) + (buttonDistanceX * positionX)),
                buttonOffsetY + buttonSizeY + ((buttonSizeY * positionY) + (buttonDistanceY * positionY)))) -- ,rgbm.colors.white,vec2(0, 0),vec2(1, 1),true)
    end

    ui.drawRect(vec2(buttonOffsetX + ((buttonSizeX * positionX) + (buttonDistanceX * positionX)),
        buttonOffsetY + ((buttonSizeY * positionY) + (buttonDistanceY * positionY))),
        vec2(buttonOffsetX + buttonSizeX + ((buttonSizeX * positionX) + (buttonDistanceX * positionX)),
            buttonOffsetY + buttonSizeY + ((buttonSizeY * positionY) + (buttonDistanceY * positionY))), color, 10, 15,
        1.5)

    if image == nil then
        display.text {
            text = text,
            pos = vec2(
                (buttonOffsetX + ((buttonSizeX * positionX) + (buttonDistanceX * positionX))) + (buttonSizeX % 2),
                (buttonOffsetY + ((buttonSizeY * positionY) + (buttonDistanceY * positionY)) + (buttonSizeY / 3))),
            color = color,
            letter = vec2(20, 40),
            font = "sls",
            width = 200,
            alignment = 0.5
        }
        display.text {
            text = state,
            pos = vec2(
                (buttonOffsetX + ((buttonSizeX * positionX) + (buttonDistanceX * positionX))) + (buttonSizeX % 2),
                (buttonOffsetY + ((buttonSizeY * positionY) + (buttonDistanceY * positionY)) + (buttonSizeY / 1.4))),
            color = color,
            letter = vec2(12.5, 25),
            font = "sls",
            width = 200,
            alignment = 0.5
        }
    end

    ui.drawRect(vec2(buttonOffsetX + ((buttonSizeX * positionX) + (buttonDistanceX * positionX)),
        buttonOffsetY + ((buttonSizeY * positionY) + (buttonDistanceY * positionY))),
        vec2(buttonOffsetX + buttonSizeX + ((buttonSizeX * positionX) + (buttonDistanceX * positionX)),
            buttonOffsetY + buttonSizeY + ((buttonSizeY * positionY) + (buttonDistanceY * positionY))), color, 10, 15,
        1.5)

    if ui.rectHovered(vec2(buttonOffsetX + ((buttonSizeX * positionX) + (buttonDistanceX * positionX)),
        buttonOffsetY + ((buttonSizeY * positionY) + (buttonDistanceY * positionY))),
        vec2(buttonOffsetX + buttonSizeX + ((buttonSizeX * positionX) + (buttonDistanceX * positionX)),
            buttonOffsetY + buttonSizeY + ((buttonSizeY * positionY) + (buttonDistanceY * positionY)))) then
        ui.drawRect(vec2(buttonOffsetX + ((buttonSizeX * positionX) + (buttonDistanceX * positionX)),
            buttonOffsetY + ((buttonSizeY * positionY) + (buttonDistanceY * positionY))),
            vec2(buttonOffsetX + buttonSizeX + ((buttonSizeX * positionX) + (buttonDistanceX * positionX)),
                buttonOffsetY + buttonSizeY + ((buttonSizeY * positionY) + (buttonDistanceY * positionY))), hoverColor,
            10, 15, 1.5)
        if ui.mouseClicked() then
            method()
        end
    end
end

function carSettings1()
    ui.drawRectFilled(vec2(0, 0), vec2(2000, 2000), rgbm(0, 0, 0, 1))
    mouseAnimation()
    local accentColor = colorWhite
    local hoverColor = rgbm(0.4, 0.4, 0.4, 1)
    local offColor = rgbm(0.1, 0.1, 0.1, 1)
    local onColor = rgbm(1, 0.1, 0, 1)
    local buttonOffsetX = 50
    local buttonOffsetY = 50
    local buttonSizeX = 200
    local buttonSizeY = 125
    local buttonDistanceX = 50
    local buttonDistanceY = 50
    local color = hoverColor
    local settings = {{
        text = "ABS",
        stateText = function()
            if (ac.getCar().extraA == true) then
                return "ON"
            else
                return "OFF"
            end
        end,
        method = function()
            absSetting = ac.getCar().absMode
            ac.setABS(absSetting + 1)
            newAbsSetting = ac.getCar().absMode
            if ((newAbsSetting == absSetting) and absSetting ~= 0) then
                ac.setABS(0)
            end
        end
    }, {
        text = "Traction Control",
        stateText = function()
            if (ac.getCar().extraA == true) then
                return "ON"
            else
                return "OFF"
            end
        end,
        method = function()
            absSetting = ac.getCar().absMode
            ac.setABS(absSetting + 1)
            newAbsSetting = ac.getCar().absMode
            if ((newAbsSetting == absSetting) and absSetting ~= 0) then
                ac.setABS(0)
            end
        end
    }, {
        text = "Turbo Wastegate",
        stateText = function()
            if (ac.getCar().extraA == true) then
                return "ON"
            else
                return "OFF"
            end
        end,
        method = function()
            absSetting = ac.getCar().absMode
            ac.setABS(absSetting + 1)
            newAbsSetting = ac.getCar().absMode
            if ((newAbsSetting == absSetting) and absSetting ~= 0) then
                ac.setABS(0)
            end
        end
    }, {
        text = "Brake Bias",
        stateText = function()
            if (ac.getCar().extraA == true) then
                return "ON"
            else
                return "OFF"
            end
        end,
        method = function()
            absSetting = ac.getCar().absMode
            ac.setABS(absSetting + 1)
            newAbsSetting = ac.getCar().absMode
            if ((newAbsSetting == absSetting) and absSetting ~= 0) then
                ac.setABS(0)
            end
        end
    }, {
        text = "DRS",
        stateText = function()
            if (ac.getCar().extraA == true) then
                return "ON"
            else
                return "OFF"
            end
        end,
        method = function()
            absSetting = ac.getCar().absMode
            ac.setABS(absSetting + 1)
            newAbsSetting = ac.getCar().absMode
            if ((newAbsSetting == absSetting) and absSetting ~= 0) then
                ac.setABS(0)
            end
        end
    }, {
        text = "KERS",
        stateText = function()
            if (ac.getCar().extraA == true) then
                return "ON"
            else
                return "OFF"
            end
        end,
        method = function()
            absSetting = ac.getCar().absMode
            ac.setABS(absSetting + 1)
            newAbsSetting = ac.getCar().absMode
            if ((newAbsSetting == absSetting) and absSetting ~= 0) then
                ac.setABS(0)
            end
        end
    }}

    local posy = 0
    local posx = -1
    for i = 1, #settings do
        local setting = settings[i].text
        posx = posx + 1
        if i > 3 then
            if (posx > 2) then
                posx = 0
            end
            posy = 1
        end
        createSettingButton(setting, rgbm(0.1, 0.1, 0.1, 1), posx, posy, settings[i].stateText(), settings[i].method,
            settings[i].state)
    end
end

function carSettings2()
    ui.drawRectFilled(vec2(0, 0), vec2(2000, 2000), rgbm(0, 0, 0, 1))
    mouseAnimation()
    local accentColor = colorWhite
    local hoverColor = rgbm(0.4, 0.4, 0.4, 1)
    local offColor = rgbm(0.1, 0.1, 0.1, 1)
    local onColor = rgbm(1, 0.1, 0, 1)
    local buttonOffsetX = 50
    local buttonOffsetY = 50
    local buttonSizeX = 200
    local buttonSizeY = 125
    local buttonDistanceX = 50
    local buttonDistanceY = 50
    local color = hoverColor
    local settings = {{
        text = "setEngineBrakeSetting",
        stateText = function()
            if (ac.getCar().extraA == true) then
                return "ON"
            else
                return "OFF"
            end
        end,
        method = function()
            absSetting = ac.getCar().absMode
            ac.setABS(absSetting + 1)
            newAbsSetting = ac.getCar().absMode
            if ((newAbsSetting == absSetting) and absSetting ~= 0) then
                ac.setABS(0)
            end
        end
    }, {
        text = "setMGUHCharging",
        stateText = function()
            if (ac.getCar().extraA == true) then
                return "ON"
            else
                return "OFF"
            end
        end,
        method = function()
            absSetting = ac.getCar().absMode
            ac.setABS(absSetting + 1)
            newAbsSetting = ac.getCar().absMode
            if ((newAbsSetting == absSetting) and absSetting ~= 0) then
                ac.setABS(0)
            end
        end
    }, {
        text = "setMGUKDelivery",
        stateText = function()
            if (ac.getCar().extraA == true) then
                return "ON"
            else
                return "OFF"
            end
        end,
        method = function()
            absSetting = ac.getCar().absMode
            ac.setABS(absSetting + 1)
            newAbsSetting = ac.getCar().absMode
            if ((newAbsSetting == absSetting) and absSetting ~= 0) then
                ac.setABS(0)
            end
        end
    }, {
        text = "setMGUKRecovery",
        stateText = function()
            if (ac.getCar().extraA == true) then
                return "ON"
            else
                return "OFF"
            end
        end,
        method = function()
            absSetting = ac.getCar().absMode
            ac.setABS(absSetting + 1)
            newAbsSetting = ac.getCar().absMode
            if ((newAbsSetting == absSetting) and absSetting ~= 0) then
                ac.setABS(0)
            end
        end
    }, {
        text = "setHeadlights",
        stateText = function()
            if (ac.getCar().extraA == true) then
                return "ON"
            else
                return "OFF"
            end
        end,
        method = function()
            absSetting = ac.getCar().absMode
            ac.setABS(absSetting + 1)
            newAbsSetting = ac.getCar().absMode
            if ((newAbsSetting == absSetting) and absSetting ~= 0) then
                ac.setABS(0)
            end
        end
    }, {
        text = "setHighBeams",
        stateText = function()
            if (ac.getCar().extraA == true) then
                return "ON"
            else
                return "OFF"
            end
        end,
        method = function()
            absSetting = ac.getCar().absMode
            ac.setABS(absSetting + 1)
            newAbsSetting = ac.getCar().absMode
            if ((newAbsSetting == absSetting) and absSetting ~= 0) then
                ac.setABS(0)
            end
        end
    }}

    local posy = 0
    local posx = -1
    for i = 1, #settings do
        local setting = settings[i].text
        posx = posx + 1
        if i > 3 then
            if (posx > 2) then
                posx = 0
            end
            posy = 1
        end
        createSettingButton(setting, rgbm(0.1, 0.1, 0.1, 1), posx, posy, settings[i].stateText(), settings[i].method,
            settings[i].state)
    end
end

function mouseAnimation()
    ui.drawCircle(ui.mousePos() - vec2(usable_offset_x, usable_offset_y), 20, colorWhite, 20, 2)
    if ui.mouseDown() == true then
        ui.drawCircle(ui.mousePos() - vec2(usable_offset_x, usable_offset_y), 15, colorWhite, 20, 1.5)
    end
end
